<?xml version="1.0" encoding="UTF-8"?>
<xsl:transform version="1.0" 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:fn="http://www.w3.org/2005/xpath-functions"		
		xmlns:mx="http://www.mobotix.com/xslfuncs">
		
<xsl:output method="html" encoding="UTF-8"/>

<xsl:variable name="translation-context">EventSearch</xsl:variable> 
<xsl:include href="include.xsl"/>

<xsl:template match="/print">

<html>
<head>
<!-- <link> doesn't work with QTextDocument ;-(	
  <link rel="stylesheet" type="text/css">
	  <xsl:attribute name="href"><xsl:value-of select="template-path"/>PrintTemplates.css</xsl:attribute>
  </link>
-->  
  <style>
    BODY, TD {
	  	font-family: "VAGRounded LT Thin";
  		font-size: 12pt;
  		color: #002080;
	  }
  	TD {
  		text-align:left;
  	}
  	P {
  		text-align:center;
  	}
  	hr {
  		color: #002080;
  		height: 2px;  			
  	}
  	.title {
		font-weight:bold;
		font-size:24pt;
		background-color: #dddddd;
		vertical-align:middle;
	}
  	.header {
  		position: absolute;
  		top:0px;
  	}
   </style>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
	<title>
	  <xsl:call-template name="tr"><xsl:with-param name="source">MxControlCenter - Video Search</xsl:with-param></xsl:call-template>
	</title>
</head>

<body>
<center>

<!-- header area	-->
<table cellspacing="0" border="0" width="100%">
<tr>
	<td class="title" align="center" width="1200px">
		<xsl:call-template name="tr"><xsl:with-param name="source">MxControlCenter - Video Search</xsl:with-param></xsl:call-template>
	</td>
	<td width="525px" align="right" bgcolor="#dddddd">
		<img width="175" height="146" border="0">
			<xsl:attribute name="src"><xsl:value-of select="template-path"/>logo.jpg</xsl:attribute>
			<xsl:attribute name="source"><xsl:value-of select="template-path"/>logo.jpg</xsl:attribute>
			<!-- note: source is for Qt compatibility, especially with whitespace in file paths !! -->
		</img>
	</td>
</tr>
</table>

<br/><br/>

<!-- event data -->
<table cellspacing="0" cellpadding="4" border="0">

<tr>
	<td><xsl:call-template name="tr"><xsl:with-param name="source">Camera IP Address</xsl:with-param></xsl:call-template>:</td>	
	<td><xsl:value-of select="data/ip"/></td>	
</tr>
<tr>
	<td><xsl:call-template name="tr"><xsl:with-param name="source">Recording Time</xsl:with-param></xsl:call-template>:</td>	
	<td><xsl:value-of select="data/recordingtime"/></td>	
</tr>
<tr>
	<td><xsl:call-template name="tr"><xsl:with-param name="source">Print Time</xsl:with-param></xsl:call-template>:</td>	
	<td><xsl:value-of select="data/printtime"/></td>
</tr>
<tr><td colspan="2">
	<img src="blue1.gif" width="640" height="2" align="center">
		<xsl:attribute name="src"><xsl:value-of select="template-path"/>blue1.gif</xsl:attribute>
	</img>
</td></tr>
</table>

<!-- original image -->
<p>
	<xsl:call-template name="tr"><xsl:with-param name="source">Original</xsl:with-param></xsl:call-template>:<br/>
	<xsl:call-template name="img-scale">
		<xsl:with-param name="img" select="image[@id='original']"/>
		<xsl:with-param name="max-width" select="paper/content/@width"/>
		<xsl:with-param name="max-height" select="paper/content/@height - 40"/>
	</xsl:call-template>	
</p>

<xsl:if test="image[@id='processed']">
	<!-- processed image -->
	<p style="page-break-before: always;">
		<xsl:call-template name="tr"><xsl:with-param name="source">Processed Image</xsl:with-param></xsl:call-template>:<br/>
		<xsl:call-template name="img-scale">
			<xsl:with-param name="img" select="image[@id='processed']"/>
			<xsl:with-param name="max-width" select="paper/content/@width"/>
			<xsl:with-param name="max-height" select="paper/content/@height - 40"/>
		</xsl:call-template>
	</p>
</xsl:if>

</center>

</body>
</html>

</xsl:template>

	
</xsl:transform>